/*
 * Copyright (c) 2016, Texas Instruments Incorporated
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * *  Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * *  Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * *  Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/*
 * \file    aic3106_main.c
 *
 * \brief   Main entry point for the AIC3104 tests
 *
 * This file contains the entry point for configuring and testing the AIC3104 Audio
 * codec on the Base Board.
 *
 * \author  0043
 *
 * \version 01a,19aug,2010 Created
 */

/*
 *====================
 * Includes
 *====================
 */
#include "stdio.h"
#include "dm388_i2c.h"
#include "dm388_EVM.h"
#include "aic3104.h"


 /*
 *====================
 * Defines
 *====================
 */

/*
 *====================
 * Function implementations
 *====================
 */
/** **************************************************************************
 * \n \brief Routine to test the AIC3104 Audio codec on Base board
 *
 * This routine initializes the AIC3104 Audio Codec on the base board to test
 * various interfaces including the following
 *	(a) Playback on Head-phohne
 *  (b) Playback on Line-Out
 *  (c) Loopback the input on Microphone to head-set.
 *  (d) Loopback the input on Line-In to Line-Out
 *
 * \param u8McaspNum	[IN]	Instance of McASP number
 *
 * \return
 * \n      return SUCCESS for success  - Description
 * \n      return FAILED for error   - Description
 */

void audio_test(void)
{
	INT32 u32RetVal = SUCCESS;
	
	//Aic3104Init();
	
	u32RetVal = aic3104_tests (1);
	
	if (u32RetVal == SUCCESS)
	{
		platform_write ("\n\nAll configuration & Playback/loopback successfully completed.\r\n");
		platform_write ("However, actual results are to be judged based on the audio \r\n");
		platform_write (" heard from the head-phone and speakers.\r\n");
	}
	else
	{
		platform_write ("Some configuration failed.\r\n");
	}
	
	

}
